% plot_psnr.m
%   script to plot the Fig.7
%
% Written: Hao Fang
% Created: Sep. 2012

clear all;
close all;
clc;

path(path, './Data');

f = {'boat.512.tiff', 'cameraman.tif', 'Lena.tiff', 'Peppers.tiff'};
LineSpec = {'b-*', 'b--*', 'r-o', 'r--o', 'g-x', 'g--x', 'k-d', 'k--d'};
figure('Position',[50 50 1200 750]);
hold all;
for ii = 1:length(f)
    filename = f{ii};
    load(sprintf('%s_noperm.mat', filename), 'PSNR', 'CR');
    plot(CR, PSNR, LineSpec{(ii-1)*2 + 1}, ...
        'LineWidth', 3, ...
        'MarkerSize', 12);
    load(sprintf('%s_zigzagperm.mat', filename), 'PSNR', 'CR');
    plot(CR, PSNR, LineSpec{ii*2}, ...
        'LineWidth', 3, ...
        'MarkerSize', 12);
end
grid on;
set(gca, 'FontSize', 20, ...
    'FontWeight', 'Bold'); 
xlabel('Compression Ratio', 'FontSize', 20, 'FontWeight', 'Bold');
ylabel('PSNR(dB)', 'FontSize', 20, 'FontWeight', 'Bold');
h_legend = legend('Boat no permutation', 'Boat zigzag-scan-based permutation', ...
       'Cameraman no permutation', 'Cameraman zigzag-scan-based permutation', ...
       'Lena no permutation', 'Lena zigzag-scan-based permutation',...
       'Peppers no permutation', 'Peppers zigzag-scan-based permutation',...
       'Location', 'SouthEast');
set(h_legend, 'FontSize', 15);
set(h_legend, 'FontWeight', 'Bold');
axis([min(CR) max(CR) 10 40]);